// Gadacz v1.1
// (c) 2002-2006 by Przemysaw Rumik
// Przemysaw Rumik - RMK
// przemyslaw.rumik+gadacz@gmail.com
// -----------------------------------------------------------------------------
// Wtyczka bazuje na kodzie przykladu z SDK do PowerGG autorstwa Ajrona
// Idee tego jak powinno sie odbierac pakiety wyswietlili mi Piotr Mach i acc
// Czesc kodu przetwarzajacego liste kontaktow jest wzorowane ;) na kodzie autorstwa
// Ajrona i zostal zaczerpniety z kodu wtyczki Sound.
// -----------------------------------------------------------------------------
// Gadacza mozna wykorzystywac jak sie chce i gdzie sie chce
// -----------------------------------------------------------------------------
// Nie publikowac zmienionych wersji!! Jezeli dokonasz zmiany i uznasz ja za dobra
// to przeslij ja na adres rmk@spec.stopklatka.pl, jezeli Twoja poprawka zostanie
// zaakceptowana i pojawi sie w kolejnej wersji Gadacza to oczywiscie Gadacz bedzie 
// zawieral informacje o Twoim autorstwie poprawki.
// W celu ulatwienia naszego wspolnego zycia :) prosze zaznaczyc miejsca poprawek
// w kodzie.
// Wiem, ze moj zakaz was nie powstrzyma, ale jednak apeluje do waszej uczciwosci
// nie publikujcie zmienionych wersji!!!
// -----------------------------------------------------------------------------
// Jezeli chcesz wykorzystac fregment kodu Gadacza [np. do komunikacji z serwerem
// mowy to prosze bardzo :), choc miloby bylo dodac wtedy krotkie info o mojej
// osobie ;)].
// -----------------------------------------------------------------------------
// Gadacz potrafi wykorzystac nastepujace synezatory mowy:
// System Syntezy Mowy WP
// UniSpiker firmy IVO
// SynTalk firmy NeuroSoft
// Dant
// probnie potrafi wg. teorii mowic poprzez SAPI, uzywajac domyslnego glosu
// -----------------------------------------------------------------------------
// Jezeli masz jakies watpliwosci i nie rozumiesz kodu to pytaj :)



#pragma comment(linker,"/FILEALIGN:0x200")

#include <io.h>
#include <fcntl.h>
#include <windows.h>
#include <process.h>
#include <stdlib.h>
#include <stdio.h>
#include "plugs.h"
#include "resource.h"
//#include "SAPI.h"

void ThreadProc(void *dummy);
UINT CALLBACK MenuProc(UINT status);
void CALLBACK ProfileProc(char *profile);
void CALLBACK BuddyProc();
BOOL CALLBACK DlgProc(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);
BOOL CALLBACK InfoDlgProc(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);
BOOL CALLBACK StartDlgProc(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam);
BOOL WINAPI DllMain(HINSTANCE hMod,DWORD fdwReason,LPVOID lpvReserved);

static BOOL DDEPokeData(LPSTR serwer,LPSTR temat,LPSTR item,LPSTR tekst);
static BOOL DDEExecute(LPSTR serwer,LPSTR temat,LPSTR item);

BOOL InicjalizujSerwer();
BOOL gadaj(LPSTR tekst);
BOOL czytajplik(LPSTR tekst);
BOOL czytajschowek(HWND hWnd);

// Zalezne od serwera mowy
BOOL gadajWP(LPSTR tekst);
BOOL gadajWP2(LPSTR tekst);
BOOL gadajIVO(LPSTR tekst);
BOOL gadajSynTalk(LPSTR tekst);
BOOL gadajDant(LPSTR tekst);
BOOL czytajplikWP(LPSTR tekst);
BOOL czytajplikIVO(LPSTR tekst);
//=========================================================================================
#pragma data_seg (".info")

char pi[]=
{
	"Gadacz :)\0"
	"1.1\0"
	"Autor: RMK (przemyslaw.rumik+gadacz@gmail.com)\r\n\r\n"
	"Wtyczka odczytuje wiadomoci przychodzce i wychodzce przy pomocy:Systemu Syntezy Mowy WP, UniSpikera firmy IVO, SynTalka firmy NeuroSoft lub syntezatora DANT."
};

#pragma data_seg ()
//=========================================================================================

HANDLE thread=NULL;
char username[256];
char userdirectory[256];
HWND hDialog;
HINSTANCE hModule;

// definicja zmiennych, w ktorych przechowamy umiejscowienie oryginalnych send i recv
int (WINAPI *_send)(SOCKET,const char *, int, int);
int (WINAPI *_recv)(SOCKET,const char *, int, int);


// Kazdy syntezator ma przyporzadkowany numer, ktory jest przechowywany w zmiennej aktualny_syntezator
#define syntezator_brak 0
#define syntezator_WP 1
#define syntezator_IVO 2
#define syntezator_WP2 3
#define syntezator_SynTalk 4
#define syntezator_Dant 5
#define syntezator_SAPI 6

// Maksymalny numer syntezatora, to jest potrzebne do autodetekcji
#define max_serwer 5

//Wersja :)
#define wersja 100

int ptaszek[]={MF_UNCHECKED,MF_CHECKED};

int active=0;				// 0 wtyczka nieaktywna, 1 wtyczka aktywna
int incoming=1;				// 0 zablokowane czytanie wiadomosci przychodzacych, 1 niezablokowane
int outcoming=1;			// 0 zablokowane czytanie wiadomosci wychodzacych, 1 niezablokowane
int change=1;				// 0 zablokowane informowania o zmianie statusu, 1 niezablokowane
int intro=0;				// 0 nie odczytuj informacji o tym kto mwi, 1 odczytuj
int version=wersja;

int self_mode=0;			// 0 wyczony tryb bezpiecznego uruchamiania
							// 1 wczony, czyli w razie kopotw z komunikacj z SSM Gadacz ustawia
							// aktualny syntezator na brak

char *serwery[]={"[brak]","System Syntezy Mowy WP","UniSpiker/Spiker firmy IVO","System Syntezy Mowy WP/2","SynTalk","Dant","SAPI"};

// Domyslnie przyjmujemy, ze nie ma zadnego syntezatora mowy
int aktualny_syntezator=syntezator_brak;

// aktualna wersja Gadacza
#define version_info "Gadacz v 1.1"

// Zdefinujmy sobie wykorzystywane strukturki :)
// Robimy to bezczebelnie za EKG

#pragma pack(1)
struct gg_recv_msg {
		int sender;		/* numer nadawcy */
		int seq;		/* numer sekwencyjny */
		int time;		/* czas nadania */
		int class;		/* klasa wiadomoci */
		char message[];	/* tre wiadomoci */
	};
#pragma pack()

#pragma pack(1)
struct gg_send_msg {
		int recipient;	/* numer odbiorcy */
		int seq;		/* numer sekwencyjny */
		int class;		/* klasa wiadomoci */
		char message[];	/* tre */
	};
#pragma pack()

#pragma pack(1)
struct gg_status {
	int uin;	        /* numer */
	int status;	        /* nowy stan */
	char description[];	/* opis, nie musi wystpi */
};
#pragma pack()

#pragma pack(1)
struct gg_notify_reply {
	int uin;			/* numerek */
	char status;		/* status danej osoby */
	int remote_ip;		/* adres ip delikwenta */
	short remote_port;	/* port, na ktrym sucha klient */
	char version;		/* wersja klienta */
	char img_size;		/* rozmiar obrazkw ktre ludzik przyjmuje */
	char unknown1;		/* znowu port? */
	char description[];	/* opis, nie musi wystpi */
};
#pragma pack()

// Struktura do przechowywania listy kontaktw

struct kontakt {
			char	imie[51];
			char	nazwisko[51];
			char	nick[51];
			char	wyswietlana[153];
			char	grupy[51];
			char	numer_telefonu[12];
			int		UIN;
			char	email[51];
			int		czy_czytac_od;
			int		czy_czytac_do;
			int		czy_powiadamiac;
			int		czy_dziewczynka;
			char	tekst_powiadomienia[64];
			int		uzywany_syntezator;
			char	nazwa_glosu[32]; // wazne dla SAPI

	};


struct kontakt * kontakty;
int ile_kontaktow=0;


//=========================================================================================
HDDEDATA CALLBACK DDECallback(UINT wType, 
                              UINT wFmt, 
                              HCONV hConv,
                              HSZ hsz1, 
                              HSZ hsz2, 
                              HDDEDATA hDDEData, 
                              DWORD dwData1, 
                              DWORD dwData2)
{
	switch (wType) {

    default:
        return NULL;
        break;
    }
}


//=========================================================================================
static BOOL DDEPokeData(LPSTR serwer,LPSTR temat,LPSTR item,LPSTR tekst)
{
    DWORD dwDDEInst = 0;
    UINT ui;
    HSZ hszServer;
	HSZ hszTopic;
	HSZ hszItem;
    HWND hWnd;
	HCONV hConv;
    HDDEDATA hExecData;
	char lpszCmd[4096];

	hWnd=GetForegroundWindow();

    ui = DdeInitialize(&dwDDEInst,
                       DDECallback,
					   CBF_FAIL_ALLSVRXACTIONS,
                       0l);

    if (ui != DMLERR_NO_ERROR) {
		SetFocus(hWnd);
		return FALSE;
    }


    hszServer = DdeCreateStringHandle(dwDDEInst,serwer,CP_WINANSI);
    hszTopic = DdeCreateStringHandle(dwDDEInst,temat,CP_WINANSI);
    hszItem = DdeCreateStringHandle(dwDDEInst,item,CP_WINANSI);



    hConv = DdeConnect(dwDDEInst,hszServer,hszTopic,NULL);

    DdeFreeStringHandle(dwDDEInst, hszServer);
    DdeFreeStringHandle(dwDDEInst, hszTopic);


    if (!hConv) {
		SetFocus(hWnd);
        return FALSE;
    }

   
	strcpy(lpszCmd,tekst);

    hExecData = DdeCreateDataHandle(dwDDEInst,
                                    lpszCmd,
                                    lstrlen(lpszCmd)+1,
                                    0,
                                    hszItem,
                                    CF_TEXT,
                                    0);

	DdeClientTransaction((void FAR *)hExecData,
                         (DWORD)-1,
                         hConv,
                         hszItem,
                         CF_TEXT,
                         XTYP_POKE,
						 //1000,
                         TIMEOUT_ASYNC,
                         NULL);
	

	DdeFreeDataHandle((void FAR *)hExecData);
    
	DdeFreeStringHandle(dwDDEInst, hszItem);



    DdeDisconnect(hConv);

    DdeUninitialize(dwDDEInst);

	SetFocus(hWnd);

    return TRUE;
}
//=========================================================================================
static BOOL DDEExecute(LPSTR serwer,LPSTR temat,LPSTR item)
{
    DWORD dwDDEInst = 0;
    UINT ui;
    HSZ hszServer;
	HSZ hszTopic;
    HCONV hConv;
	HWND hWnd;
    HDDEDATA hExecData;
	char lpszCmd[4096];

	hWnd=GetForegroundWindow();

    ui = DdeInitialize(&dwDDEInst,
                       DDECallback,
                       CBF_FAIL_ALLSVRXACTIONS,
                       0l);

    if (ui != DMLERR_NO_ERROR) {
        SetFocus(hWnd);
		return FALSE;
    }


    hszServer = DdeCreateStringHandle(dwDDEInst,serwer,CP_WINANSI);
    hszTopic = DdeCreateStringHandle(dwDDEInst,temat,CP_WINANSI);
    

    hConv = DdeConnect(dwDDEInst,hszServer,hszTopic,NULL);

    DdeFreeStringHandle(dwDDEInst, hszServer);
    DdeFreeStringHandle(dwDDEInst, hszTopic);


    if (!hConv) {
        SetFocus(hWnd);
		return FALSE;
    }

    strcpy(lpszCmd,item);
    
    hExecData = DdeCreateDataHandle(dwDDEInst,
                                    lpszCmd,
                                    lstrlen(lpszCmd)+1,
                                    0,
                                    0,
                                    CF_TEXT,
                                    0);

    DdeClientTransaction((void FAR *)hExecData,
                         (DWORD)-1,
                         hConv,
                         0,
                         0,
                         XTYP_EXECUTE,
//                         100, // ms timeout
						 TIMEOUT_ASYNC,
                         NULL);

	DdeFreeDataHandle((void FAR *)hExecData);

    DdeDisconnect(hConv);

    DdeUninitialize(dwDDEInst);

	SetFocus(hWnd);
    return TRUE;
}
//=========================================================================================
// Okazuje sie, ze gdy stosuje sie schemat: DDEInitialize, DDEPoke, DDEUninitalize, 
// DDEInitialize, DDEExecute, DDEUninitalize to SynTalk nie zawsze poprawnie czyta teksty.
// Dlatemu jest ta probna wersja, ktora proboje to zrobic w trakcie jednej transakcji
static BOOL DDEPokeExecute(LPSTR serwer,LPSTR Ptemat,LPSTR Pitem,LPSTR tekst,LPSTR Etemat, LPSTR Eitem)
{
    DWORD dwDDEInst = 0;
    UINT ui;
    HSZ hszServer;
	HSZ hszTopic;
	HSZ hszItem;
    HWND hWnd;
	HCONV hConv;
    HDDEDATA hExecData;
	char lpszCmd[4096];

	hWnd=GetForegroundWindow();

    ui = DdeInitialize(&dwDDEInst,
                       DDECallback,
					   CBF_FAIL_ALLSVRXACTIONS,
                       0l);

    if (ui != DMLERR_NO_ERROR) {
		SetFocus(hWnd);
		return FALSE;
    }


    hszServer = DdeCreateStringHandle(dwDDEInst,serwer,CP_WINANSI);
    hszTopic = DdeCreateStringHandle(dwDDEInst,Ptemat,CP_WINANSI);
    hszItem = DdeCreateStringHandle(dwDDEInst,Pitem,CP_WINANSI);



    hConv = DdeConnect(dwDDEInst,hszServer,hszTopic,NULL);

//    DdeFreeStringHandle(dwDDEInst, hszServer);
    DdeFreeStringHandle(dwDDEInst, hszTopic);


    if (!hConv) {
		SetFocus(hWnd);
        return FALSE;
    }

   
	strcpy(lpszCmd,tekst);

    hExecData = DdeCreateDataHandle(dwDDEInst,
                                    lpszCmd,
                                    lstrlen(lpszCmd)+1,
                                    0,
                                    hszItem,
                                    CF_TEXT,
                                    0);

	DdeClientTransaction((void FAR *)hExecData,
                         (DWORD)-1,
                         hConv,
                         hszItem,
                         CF_TEXT,
                         XTYP_POKE,
						 //1000,
                         TIMEOUT_ASYNC,
                         NULL);
	

	DdeFreeDataHandle((void FAR *)hExecData);
    
	DdeFreeStringHandle(dwDDEInst, hszItem);



    hszTopic = DdeCreateStringHandle(dwDDEInst,Etemat,CP_WINANSI);
    

    hConv = DdeConnect(dwDDEInst,hszServer,hszTopic,NULL);

    DdeFreeStringHandle(dwDDEInst, hszServer);
    DdeFreeStringHandle(dwDDEInst, hszTopic);


    if (!hConv) {
        SetFocus(hWnd);
		return FALSE;
    }

    strcpy(lpszCmd,Eitem);
    
    hExecData = DdeCreateDataHandle(dwDDEInst,
                                    lpszCmd,
                                    lstrlen(lpszCmd)+1,
                                    0,
                                    0,
                                    CF_TEXT,
                                    0);

    DdeClientTransaction((void FAR *)hExecData,
                         (DWORD)-1,
                         hConv,
                         0,
                         0,
                         XTYP_EXECUTE,
//                         100, // ms timeout
						 TIMEOUT_ASYNC,
                         NULL);

	DdeFreeDataHandle((void FAR *)hExecData);





    DdeDisconnect(hConv);

    DdeUninitialize(dwDDEInst);

	SetFocus(hWnd);

    return TRUE;
}
//=========================================================================================
// Zwraca numer w tablicy kontakty dla danego UINa :)
int znajdz_kontakt(int UIN)
{
	int i=0;
	if (ile_kontaktow>0)
	while ((i<ile_kontaktow) && (kontakty[i].UIN!=UIN)) i++;	
	return i;
};

//=========================================================================================

void WczytajCFG()
{
	char	*dane;
	char	*pos;
	DWORD	*ofs;
	char	*fpos;
	char	smseab[512];
	char	namiary[512];
	int		len;
	int		aktualny;
	int		f;
	int		l;
	int		i;

	char	fname[512];
	char	st[256];
	FILE	*f_;

	// Sklejamy nazw pliku z list kontaktw
	version=0;
	strcpy(smseab,userdirectory);
	strcat(smseab,"smseab.dat");

	if ((f=open(smseab,O_RDONLY|O_BINARY))!=-1)
	{
		len=filelength(f);
		if ((dane=(char *)malloc(len+1))!=NULL)
		{
			memset(dane,0,len+1);
			read(f,dane,len);
			close(f);

			// Sprawdzamy czy mamy do czynienia ze znanym formatem pliku z kontaktami
			if (!strcmp(dane,"dbfile3."))
			{
				//przeskakujemy naglowek
				pos=dane+9;
				ofs=(DWORD *)pos;
				//w len dlugosc listy kontaktow
				len=*ofs++;
	
				itoa(len,smseab,10);
	
				pos+=(len+1)*4;
			
				fpos=pos;

				//a nuz kontakty juz byly wypelniane?
				if (kontakty!=NULL) free(kontakty);
				//rezerwujemy memorke pod liste kontaktow
				kontakty=(struct kontakt *)malloc(sizeof(struct kontakt)*(len+1));
			
				aktualny=0;
			
				for (i=0; i<len; i++)
				{
					//No to siup do i-tego kontaktu
					l=*ofs++;
					pos=fpos+l;
	
					strncpy(kontakty[aktualny].imie,(char *)pos,50);
					pos+=strlen((char *)pos)+1;

					strncpy(kontakty[aktualny].nazwisko,(char *)pos,50);
					pos+=strlen((char *)pos)+1;

					strncpy(kontakty[aktualny].nick,(char *)pos,50);
					pos+=strlen((char *)pos)+1;
				
					strncpy(kontakty[aktualny].wyswietlana,(char *)pos,153);
					pos+=strlen((char *)pos)+1;
				
					strncpy(namiary,(char *)pos,512);
					pos+=strlen((char *)pos)+1;

					strncpy(kontakty[aktualny].grupy,(char *)pos,50);
					pos+=strlen((char *)pos)+1;
				
					pos++;
				
					pos=strchr(namiary,';')+1;

					strcpy(namiary,(char *)pos);

					kontakty[aktualny].UIN=atoi(namiary);
				
					kontakty[aktualny].czy_czytac_do=1;

					kontakty[aktualny].czy_czytac_od=1;

					kontakty[aktualny].czy_powiadamiac=1;
					
					kontakty[aktualny].czy_dziewczynka=0;

					strncpy(kontakty[aktualny].tekst_powiadomienia,"",63);

					//jezeli UIN=0 to mozemy spokojnie na to pisac od nowa
					if (kontakty[aktualny].UIN!=0) aktualny++;

				};

				//Dodajemy nowy kontakt, ktory posluzy nam jako miejsce trzymania
				//wszystkich spoza listy
				kontakty[aktualny].UIN=0;			// UIN=0 ludzie spoza listy
				strcpy(kontakty[aktualny].wyswietlana,"[osoby spoza listy kontaktw]");
				kontakty[aktualny].czy_czytac_od=0;
				kontakty[aktualny].czy_czytac_do=0;
				kontakty[aktualny].czy_powiadamiac=0;
				kontakty[aktualny].czy_dziewczynka=0;

				ile_kontaktow=aktualny;

				//sklejamy sciazke i nazwe do pliku z konfiguracja Gadacza
				strcpy(fname,userdirectory);
				strcat(fname,"gadacz.cfg");

				if ((f_=fopen(fname,"rt"))!=NULL)

				{

					while (fgets(st,256,f_)!=NULL)
					{
						
						if (strstr(st,"active=")==st) active=(st[7]=='1');

						if (strstr(st,"incoming=")==st) incoming=(st[9]=='1');

						if (strstr(st,"outcoming=")==st) outcoming=(st[10]=='1');

						if (strstr(st,"change=")==st) change=(st[7]=='1');

						if (strstr(st,"intro=")==st) intro=(st[6]=='1');

						// gorzej jak bedzie kiedys wiecej niz 10 syntezatorow ;)
						if (strstr(st,"serwer=")==st) aktualny_syntezator=atoi((st+7));

						if (strstr(st,"version=")==st) version=atoi(st+8);

						if (strstr(st,"self=")==st) self_mode=atoi(st+5);
						
						if (strstr(st,"item=")==st)
							{
								pos=st+5;
								
								i=znajdz_kontakt(atoi(pos));
	
								itoa(kontakty[i].UIN,namiary,10);

								pos+=strlen(namiary)+1;
								kontakty[i].czy_czytac_od=(pos[0]=='1');
							
								pos+=2;
							
								kontakty[i].czy_czytac_do=(pos[0]=='1');
								pos+=2;
							
								kontakty[i].czy_powiadamiac=(pos[0]=='1');
								pos+=2;

								kontakty[i].czy_dziewczynka=(pos[0]=='1');
								pos+=2;

								strcpy(kontakty[i].tekst_powiadomienia,pos);

							};
								
					};	

					fclose(f_);

				};

			free(dane);
			}
			else MessageBox(0,"Za mao pamici","Bd",0);

		}
		else MessageBox(0,"Plik z list kontaktw jest w nieznanym mi formacie :(","Bd",0);

	}
	else MessageBox(0,"Nie mog otworzy pliku z list kontaktw.","Bd",0);

	if (version<wersja) {
		//MessageBox(0,namiary,"",0);
		DialogBox(hModule,MAKEINTRESOURCE(IDD_START),NULL,StartDlgProc);
	
	};

};

//=========================================================================================
char* zmienna(char *co,int wart)
{
	static char	pom[1024];
	char		st[256];
	
	itoa(wart,st,10);
	
	strcpy(pom,co);
	strcat(pom,"=");
	strcat(pom,st);
	strcat(pom,"\n");

	return pom;
};
//=========================================================================================
void ZapiszCFG()
{
	char fname[512];
	char st[256];
	FILE *f;
	int	i;

    //sklejamy sciezke i nazwe pliku konfiguracyjnego Gadacza
	strcpy(fname,userdirectory);
	strcat(fname,"gadacz.cfg");

	f=fopen(fname,"wt");

	//liczny tekst na grze pliku ;)
	fputs("# Plik konfiugracyjny Gadacza\n",f);
	fputs("# lepiej nie grzeba ;) bo moe co nie zadziaa\n",f);
	fputs("# kontakt z autorem : rmk@spec.stopklatka.pl\n\n",f);
	//zapisujemy globalne ustawienia wtyczki

	fputs(zmienna("active",active),f);
	fputs(zmienna("incoming",incoming),f);
	fputs(zmienna("outcoming",outcoming),f);
	fputs(zmienna("change",change),f);
	fputs(zmienna("intro",intro),f);
	fputs(zmienna("serwer",aktualny_syntezator),f);
	fputs(zmienna("version",wersja),f);
	fputs(zmienna("self",self_mode),f);

	//zapisujemy konfiguracje dla poszczegolnych kontaktow
	for (i=0; i<=ile_kontaktow; i++)
	{
		itoa(kontakty[i].UIN,st,10);
		fputs("item=",f);
		fputs(st,f);
		fputc(';',f);
		
		itoa(kontakty[i].czy_czytac_od,st,10);
		fputs(st,f);
		fputc(';',f);
		
		itoa(kontakty[i].czy_czytac_do,st,10);
		fputs(st,f);
		fputc(';',f);
		
		itoa(kontakty[i].czy_powiadamiac,st,10);
		fputs(st,f);
		fputc(';',f);

		itoa(kontakty[i].czy_dziewczynka,st,10);
		fputs(st,f);
		fputc(';',f);

		fputs(kontakty[i].tekst_powiadomienia,f);
		fputc('\n',f);

	};
	fclose(f);
};


//=========================================================================================

void WstawKonfiguracjaDlaKontaktu(HWND hWnd)
{
	int i;
	EnableWindow(GetDlgItem(hWnd,IDC_CHECK1),TRUE);
	EnableWindow(GetDlgItem(hWnd,IDC_CHECK2),TRUE);
	EnableWindow(GetDlgItem(hWnd,IDC_CHECK3),TRUE);
	EnableWindow(GetDlgItem(hWnd,IDC_CHECK8),TRUE);
	EnableWindow(GetDlgItem(hWnd,IDC_BUTTON3),TRUE);
	EnableWindow(GetDlgItem(hWnd,IDC_EDIT1),FALSE);
	SetWindowText(GetDlgItem(hWnd,IDC_EDIT1),"");
	i=SendMessage(GetDlgItem(hWnd,IDC_LIST1),LB_GETCURSEL,0,0);
	CheckDlgButton(hWnd,IDC_CHECK1,kontakty[i].czy_czytac_od);
	CheckDlgButton(hWnd,IDC_CHECK2,kontakty[i].czy_czytac_do);
	CheckDlgButton(hWnd,IDC_CHECK3,kontakty[i].czy_powiadamiac);
	CheckDlgButton(hWnd,IDC_CHECK8,kontakty[i].czy_dziewczynka);
	if (kontakty[i].czy_powiadamiac) 
	{
		EnableWindow(GetDlgItem(hWnd,IDC_EDIT1),TRUE);
		SetWindowText(GetDlgItem(hWnd,IDC_EDIT1),kontakty[i].tekst_powiadomienia);
	};
};

//=========================================================================================

BOOL CALLBACK DlgProc(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	int	i;
	char buf[1024];
	OPENFILENAME ofn;
	switch (msg)
	{
		case WM_INITDIALOG:

			hDialog=hWnd;
			SetWindowText(hWnd,version_info);
			SetWindowText(GetDlgItem(hWnd,IDC_VERSION),version_info);

			WczytajCFG();		

			EnableWindow(GetDlgItem(hWnd,IDC_CHECK1),FALSE);
			EnableWindow(GetDlgItem(hWnd,IDC_CHECK2),FALSE);
			EnableWindow(GetDlgItem(hWnd,IDC_CHECK3),FALSE);
			EnableWindow(GetDlgItem(hWnd,IDC_CHECK8),FALSE);
			EnableWindow(GetDlgItem(hWnd,IDC_EDIT1),FALSE);
			EnableWindow(GetDlgItem(hWnd,IDC_BUTTON3),FALSE);

			CheckDlgButton(hWnd,IDC_CHECK9,self_mode);

			CheckDlgButton(hWnd,IDC_CHECK4,active);			

			SendMessage(GetDlgItem(hWnd,IDC_LIST1),LB_RESETCONTENT,0,0);

			
			for (i=0; i<=ile_kontaktow; i++)
			{
				if (kontakty[i].UIN)
				SendMessage(GetDlgItem(hWnd,IDC_LIST1),LB_ADDSTRING,0,(LONG)kontakty[i].wyswietlana);

			};
			
			SendMessage(GetDlgItem(hWnd,IDC_LIST1),LB_ADDSTRING,0,(LONG)kontakty[ile_kontaktow].wyswietlana);

			SendMessage(GetDlgItem(hWnd,IDC_LIST1),LB_SETCURSEL,0,0);

			WstawKonfiguracjaDlaKontaktu(hWnd);

			SetFocus(GetDlgItem(hWnd,IDC_LIST1));

			CheckDlgButton(hWnd,IDC_CHECK5,!incoming);
			CheckDlgButton(hWnd,IDC_CHECK6,!outcoming);
			CheckDlgButton(hWnd,IDC_CHECK7,!change);
			CheckDlgButton(hWnd,IDC_CHECK10,intro);

			for (i=0; i<=max_serwer; i++)
			{
				SendMessage(GetDlgItem(hWnd,IDC_COMBO1),CB_ADDSTRING,0,(LONG)serwery[i]);
			};
			SendMessage(GetDlgItem(hWnd,IDC_COMBO1),CB_SETCURSEL,aktualny_syntezator,0);

			
			return TRUE;

		 		

		 case WM_COMMAND:
				switch (LOWORD(wParam))
				{
					case IDC_BUTTON1 :		// Zamknicie dialogu Gadacza
						active=IsDlgButtonChecked(hWnd,IDC_CHECK4);
						self_mode=IsDlgButtonChecked(hWnd,IDC_CHECK9);
						ZapiszCFG();
						SendMessage(hWnd,WM_CLOSE,0,0);
						return TRUE;

					case IDC_BUTTON2 :		// Zamknicie dialogu Gadacza przez Anuluj
						SendMessage(hWnd,WM_CLOSE,0,0);
						return TRUE;

					case IDC_BUTTON3:		// Zapisanie konfiguracji

						i=SendMessage(GetDlgItem(hWnd,IDC_LIST1),LB_GETCURSEL,0,0);
						kontakty[i].czy_czytac_od=IsDlgButtonChecked(hWnd,IDC_CHECK1);
						kontakty[i].czy_czytac_do=IsDlgButtonChecked(hWnd,IDC_CHECK2);
						kontakty[i].czy_powiadamiac=IsDlgButtonChecked(hWnd,IDC_CHECK3);
						kontakty[i].czy_dziewczynka=IsDlgButtonChecked(hWnd,IDC_CHECK8);
						if (kontakty[i].czy_powiadamiac) GetWindowText(GetDlgItem(hWnd,IDC_EDIT1),kontakty[i].tekst_powiadomienia,255);

						ZapiszCFG();

						return TRUE;

					case IDC_BUTTON4:
						DialogBox(hModule,MAKEINTRESOURCE(IDD_INFO),NULL,InfoDlgProc);
						return TRUE;

					case IDC_BUTTON5:
						
						InicjalizujSerwer();
						
						strcpy(buf,"Jeeli syszysz teraz tekst to wtyczka dziaa");
						if (gadaj(buf))
						{
							MessageBox(hWnd,buf,"Test wtyczki",0);
							//if (DDERequestData("rozmowy","Festival","FestivalItem",buf))
							//MessageBox(hWnd,buf,"Test wtyczki",0);
						}
						else
						MessageBox(hWnd,"Nie wykryto syntezatora mowy!!!\n\nJeeli jest zainstalowany to prosze go uruchomi!!!\nJeeli nie ma go w systemie naley go zainstalowa. Wicej informacji w dokumentacji oraz na stronie Gadacza","Bd!! Brak serwera syntezy mowy.",0);
												
						return TRUE;
						
					case IDC_BUTTON6:
						incoming=!IsDlgButtonChecked(hWnd,IDC_CHECK5);
						outcoming=!IsDlgButtonChecked(hWnd,IDC_CHECK6);
						change=!IsDlgButtonChecked(hWnd,IDC_CHECK7);
						intro=IsDlgButtonChecked(hWnd,IDC_CHECK10);
						ZapiszCFG();
						return TRUE;

					case IDC_BUTTON7 :		// Zgo bd
/*						strcpy(buf,"mailto:gadacz@gower.pl?Subject=\"");
						strcat(buf,version_info);
						strcat(buf," - Blad\"");
						ShellExecute(hWnd,"open",buf,NULL,NULL,SW_SHOWNORMAL);*/

						return TRUE;

					case IDC_BUTTON8 :		// Czytaj plik z dysku
						strcpy(buf,"");
						memset(&ofn,0,sizeof(ofn));
						ofn.lStructSize=sizeof(ofn);
						ofn.hwndOwner=hWnd;
						ofn.lpstrFile=buf;
						ofn.nMaxFile=sizeof(buf);
						ofn.lpstrFilter="Pliki tekstowe (*.txt)\0*.txt\0Wszystkie pliki (*.*)\0*.*\0";
						ofn.nFilterIndex=1;
						ofn.lpstrTitle="Wybierz plik do czytania:";
						ofn.Flags=OFN_EXPLORER|OFN_PATHMUSTEXIST|OFN_FILEMUSTEXIST;

						if(!GetOpenFileName(&ofn)) return TRUE;

						czytajplik(buf);

						return TRUE;

					case IDC_BUTTON9 :
						czytajschowek(hWnd);
						return 0;

					case IDC_LIST1:
						if ((HIWORD(wParam)==LBN_SELCHANGE))
						{
							WstawKonfiguracjaDlaKontaktu(hWnd);

						};
						return TRUE;

					case IDC_CHECK3:
						EnableWindow(GetDlgItem(hWnd,IDC_EDIT1),IsDlgButtonChecked(hWnd,IDC_CHECK3));
						return TRUE;

					case IDC_CHECK9:
						self_mode=IsDlgButtonChecked(hWnd,IDC_CHECK9);		
						return TRUE;

					case IDC_COMBO1:
						if ((HIWORD(wParam)==CBN_SELCHANGE))
						{
							i=SendMessage(GetDlgItem(hWnd,IDC_COMBO1),CB_GETCURSEL,0,0);
							if (i!=CB_ERR) aktualny_syntezator=i;
							ZapiszCFG();
						};
						return TRUE;

					
				};
			  return TRUE;

		



		case WM_CLOSE:

			hDialog=NULL;
			EndDialog(hWnd,TRUE);
			if(MenuSet)	MenuSet((DWORD)MenuProc,ptaszek[active]);
			return TRUE;
	}
	return FALSE;
}
//=========================================================================================

BOOL CALLBACK StartDlgProc(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	char tekst[512];
	int	i;
	switch (msg)
	{
		case WM_INITDIALOG:

			hDialog=hWnd;

			aktualny_syntezator=0;

			strcpy(tekst,"To jest pierwsze uruchomienie wtyczki ");
			strcat(tekst,version_info);
			strcat(tekst,".\n\nWybierz syntezator mowy, z ktrego ma korzysta Gadacz.\nSyntezator musi by wczony!!!\nJeeli jest teraz wyczony, wybierz \"[brak]\"");

			SetWindowText(GetDlgItem(hWnd,IDC_INFO),tekst);

			for (i=0; i<=max_serwer; i++)
			{
				SendMessage(GetDlgItem(hWnd,IDC_COMBO1),CB_ADDSTRING,0,(LONG)serwery[i]);
			};

			
			SendMessage(GetDlgItem(hWnd,IDC_COMBO1),CB_SETCURSEL,0,0);
			
			return TRUE;

		 		

		 case WM_COMMAND:
				switch (LOWORD(wParam))
				{
					case IDOK:
						ZapiszCFG();
						SendMessage(hWnd,WM_CLOSE,0,0);
						return TRUE;


					case IDC_COMBO1:
						if ((HIWORD(wParam)==CBN_SELCHANGE))
						{
							i=SendMessage(GetDlgItem(hWnd,IDC_COMBO1),CB_GETCURSEL,0,0);
							if (i!=CB_ERR) aktualny_syntezator=i;
							ZapiszCFG();
						};
						return TRUE;

					case IDC_BUTTON1:
						i=max_serwer;
						do
						{
							aktualny_syntezator=i--;
							SendMessage(GetDlgItem(hWnd,IDC_COMBO1),CB_SETCURSEL,aktualny_syntezator,0);
						} while (!gadaj("autodetekcja"));
						ZapiszCFG();
						return TRUE;

					
				};
			  return TRUE;

		


		case WM_CLOSE:

			hDialog=NULL;
			EndDialog(hWnd,TRUE);
			return TRUE;
	}
	return FALSE;
}
//=========================================================================================

BOOL CALLBACK InfoDlgProc(HWND hWnd,UINT msg,WPARAM wParam,LPARAM lParam)
{
	switch (msg)
	{
		case WM_INITDIALOG:

			hDialog=hWnd;
			SetWindowText(GetDlgItem(hWnd,IDC_VERSION),version_info);
			
			
			return TRUE;

		 		

		 case WM_COMMAND:
				switch (LOWORD(wParam))
				{
					case IDOK:
						SendMessage(hWnd,WM_CLOSE,0,0);
						return TRUE;

					case IDC_BUTTON1 :		// Otwarcie strony Gadacza :)
						ShellExecute(hWnd,"open","http://www.buffypedia.prv.pl/gadacz.html",NULL,NULL,SW_SHOWNORMAL);
						return TRUE;
					case IDC_BUTTON2 :		// Otwarcie Buffypedi :)
						ShellExecute(hWnd,"open","http://przemelek.blogspot.com",NULL,NULL,SW_SHOWNORMAL);
						return TRUE;
						
				};
			  return TRUE;

		



		case WM_CLOSE:

			hDialog=NULL;
			EndDialog(hWnd,TRUE);
			return TRUE;
	}
	return FALSE;
}
//=========================================================================================

BOOL InicjalizujSerwer()
{
	if (aktualny_syntezator==syntezator_WP) return DDEExecute("rozmowy","synteza","gadacz");
	if (aktualny_syntezator==syntezator_WP2) return DDEExecute("rozmowy","synteza","gadacz");
	if (aktualny_syntezator==syntezator_brak) return TRUE;
//	if (aktualny_syntezator==syntezator_SAPI) return(InitSAPI());
	return FALSE;
};

//=========================================================================================
// Gadamy :) A wlasciwie to wybieramy przez ktora funkcje bedziemy gadac :)
BOOL gadaj(LPSTR tekst)
{
	BOOL result;
	switch (aktualny_syntezator)
	{
	case syntezator_brak:
			result=TRUE;
			break;
	case syntezator_WP:
			result=gadajWP(tekst); 
			break;
	case syntezator_WP2:
			result=gadajWP2(tekst); 
			break;
	case syntezator_IVO:
			result=gadajIVO(tekst); 
			break;
	case syntezator_SynTalk:
			result=gadajSynTalk(tekst);
			break;
	case syntezator_Dant:
			result=gadajDant(tekst);
			break;
	case syntezator_SAPI:
//			result=gadajSAPI(tekst);
			break;

	default: 
			result=FALSE;
			break;
	};
	if (self_mode)
	if (!result)
	{
		MessageBox(0,"Nie mog skomunikowa si z wybranym przez Ciebie syntezatorem mowy.\nW celu zapewnienia stabilnoci systemu zmieniam aktualny syntezator mowy na [brak].\nDo starych ustawie moesz powrci dokonujc zmiany w oknie konfiguracyjnym Gadacza.","Bd!!!",0);
		aktualny_syntezator=syntezator_brak;
	};
	return result;
};
//=========================================================================================
BOOL czytajplik(LPSTR nazwa)
{
	switch (aktualny_syntezator)
	{
	case syntezator_brak:
			return TRUE;
	case syntezator_WP:
			return czytajplikWP(nazwa); 
	case syntezator_WP2:
			return czytajplikWP(nazwa); 
	case syntezator_IVO:
			return czytajplikIVO(nazwa);
	case syntezator_SynTalk:
			return czytajplikIVO(nazwa);
//	case syntezator_SAPI:
//			return czytajplikSAPI(nazwa);
	};
	return FALSE;
};
//=========================================================================================	
BOOL czytajschowek(HWND hWnd)
{
	HANDLE handle;
	char *dane;
	//char *lpszCmd;
	//int i;
	if (!OpenClipboard(hWnd))
	{
		MessageBox(hWnd,"Brak dostpu do schowka!\nJaka aplikacja nie zwolnia go.","Bd",0);
		return FALSE;
	};
	if ((handle=GetClipboardData(CF_TEXT))!=NULL)
	{
		dane=GlobalLock(handle);
		GlobalUnlock(handle);
		CloseClipboard();	
		
		/*lpszCmd=(char *)malloc(strlen(dane)*2);
		
		strcpy(lpszCmd,"");
		for (i=0; i<strlen(dane); i++)
			if (dane[i]!='\"') strncat(lpszCmd,(char *)dane[i],1);
			else strcat(lpszCmd," czudzysw ");*/


		if (strlen(dane)<=4096) 
		{
		/*lpszCmd=(char *)malloc(strlen(dane)+256);
		
		strcpy(lpszCmd,"");
		strcat(lpszCmd,"SEvalCommand|(tts_text ");
		strcat(lpszCmd,"\"");	
		strcat(lpszCmd,"fst\\\\\\\\(chr\\\\0\\\\");
		strcat(lpszCmd,dane);
		strcat(lpszCmd,"\\\\)\\\\)");
		strcat(lpszCmd,"\"");
		strcat(lpszCmd,"'parsed)|3");
		
		
		if (DDEExecute("rozmowy","synteza","SInit|0")) 
		if (DDEExecute("rozmowy","synteza","gadacz"))
				DDEPokeData("rozmowy","synteza","gadaczIN",lpszCmd);

		//MessageBox(0,lpszCmd,"",0);
		free(lpszCmd);*/
		return(gadaj(dane));
		} else gadaj("Tekst zbyt duy, umie go w pliku i wybierz czytanie plikw.");

	} else CloseClipboard();
	return(FALSE);
};
//=========================================================================================
// Gadamy przez syntezator mowy WP
BOOL gadajWP(LPSTR tekst)
{
	char lpszCmd[4096];
	char tekst_[4096];
	int i;

	if (DDEExecute("rozmowy","synteza","SInit|3")) 
	{
		strcpy(tekst_,tekst);

		i=0;
		while (tekst_[i]!='\0') 
		{
			if (tekst_[i]=='\"') tekst_[i]=' ';
			/*if (tekst_[i]=='.') tekst_[i]='.';
			if (tekst_[i]=='!') tekst_[i]=' ';
			if (tekst_[i]=='?') tekst_[i]=' ';
			if (tekst_[i]==',') tekst_[i]=' ';*/

			i++;
		};

		strcpy(lpszCmd,"");
		strcat(lpszCmd,"SEvalCommand|(tts_text ");
		strcat(lpszCmd,"\"");	
		strcat(lpszCmd,"fst\\\\\\\\(chr\\\\0\\\\");
		strcat(lpszCmd,tekst_);
		strcat(lpszCmd,"\\\\)\\\\)");
		strcat(lpszCmd,"\"");
		strcat(lpszCmd,"'parsed)|3");
		
	/*strcpy(lpszCmd,"SEvalCommand(SayText \"");
	strcat(lpszCmd,tekst);
	strcat(lpszCmd,"\")|3");*/

		if (DDEExecute("rozmowy","synteza","gadacz"))
		{
			return(DDEPokeData("rozmowy","synteza","gadaczIN",lpszCmd));
		};
	};
	return FALSE;
}
//=========================================================================================
BOOL gadajWP2(LPSTR tekst)
{
	char lpszCmd[4096];
	char tekst_[4096];
	int i;

	if (DDEExecute("rozmowy","synteza","SInit|3")) 
	{
		strcpy(tekst_,tekst);

		i=0;
		while (tekst_[i]!='\0') 
		{
			if (tekst_[i]=='\"') tekst_[i]=' ';
			i++;
		};

		strcpy(lpszCmd,"");
		strcat(lpszCmd,"SEvalCommand|(tts_text ");
		strcat(lpszCmd,"\"");	
		strcat(lpszCmd,"fst\\\\\\\\(chr\\\\0\\\\");
		strcat(lpszCmd,tekst_);
		strcat(lpszCmd,"\\\\)\\\\)");
		strcat(lpszCmd,"\"");
		strcat(lpszCmd,"'parsed)|3");
		
	/*strcpy(lpszCmd,"SEvalCommand(SayText \"");
	strcat(lpszCmd,tekst);
	strcat(lpszCmd,"\")|3");*/

		//if (DDEExecute("rozmowy","synteza","gadacz"))
		{
			return(DDEPokeData("rozmowy","synteza","gadaczIN",lpszCmd));
		};
	};
	return FALSE;
}
//=========================================================================================
// Gadamy przez serwer mowy firmy IVO
BOOL gadajIVO(LPSTR tekst)
{
	char *lpszCmd;
	lpszCmd=(char *)malloc(strlen(tekst)+7);
	strcpy(lpszCmd,"SayIt|");
	strcat(lpszCmd,tekst);
	return(DDEPokeData("unispiker","synteza","do_serwera",lpszCmd));
	free(lpszCmd);
};
//=========================================================================================
// Gadamy przez SynTalka
BOOL gadajSynTalk(LPSTR tekst)
{
	//char *lpszCmd;
	//lpszCmd=(char *)malloc(strlen(tekst)+7);
	//strcpy(lpszCmd,"read ");
	//strcpy(lpszCmd,tekst);
	//if (DDEPokeData("Syntalk", "System", "text", tekst)) return(DDEExecute("Syntalk", "System", "[read]"));
//		else return FALSE;
	return(DDEPokeExecute("Syntalk","System","text",tekst,"System","[read]"));
	//free(lpszCmd);
};
//=========================================================================================
// Gadamy przez Danta
BOOL gadajDant(LPSTR tekst)
{
	HWND hWnd = hDialog;
	HGLOBAL hGlobal;

	
	HGLOBAL hText;
	char *pText;

	//char *lpszCmd;
	//lpszCmd=(char *)malloc(strlen(tekst)+7);
	//strcpy(lpszCmd,"read ");
	//strcpy(lpszCmd,tekst);
	//if (DDEPokeData("Syntalk", "System", "text", tekst)) return(DDEExecute("Syntalk", "System", "[read]"));
	if (!OpenClipboard(NULL))
	{
		MessageBox(hWnd,"Brak dostpu do schowka!\nJaka aplikacja nie zwolnia go.","Bd",0);
		return FALSE;
	};

	//int len = strlen(tekst);
	/*EmptyClipboard();
	hGlobal = GlobalAlloc(GMEM_MOVEABLE,strlen(tekst));
	strcpy(hGlobal,tekst);
	
	SetClipboardData(CF_TEXT,hGlobal);
	CloseClipboard();*/


	hText = GlobalAlloc(GMEM_DDESHARE | GMEM_MOVEABLE, strlen(tekst)+1);
	pText = GlobalLock(hText);
	lstrcpy(pText, tekst);
	GlobalUnlock(hText);

	EmptyClipboard();
	SetClipboardData(CF_TEXT, hText);
	CloseClipboard();

	return 1;
	//free(lpszCmd);
};
//=========================================================================================
BOOL czytajplikWP(LPSTR nazwa)
{
	char lpszCmd[4096];
	strcpy(lpszCmd,"SSayFile|");
	strcat(lpszCmd,nazwa);
	strcat(lpszCmd,"|3");
	
	if (DDEExecute("rozmowy","synteza","SInit|0")) 
		if (DDEExecute("rozmowy","synteza","gadacz"))
			return DDEPokeData("rozmowy","synteza","gadaczIN",lpszCmd);
	return FALSE;
};
//=========================================================================================
BOOL czytajplikIVO(LPSTR nazwa)
{
 char *tekst;
 FILE *f;
 BOOL result=FALSE;
 int fsize;
 if ((f=fopen(nazwa,"rt"))!=NULL)
 {
	 fseek(f,0,SEEK_END);
	 fsize=ftell(f);
	 fseek(f,0,SEEK_SET);
	 tekst=(char *)malloc(fsize+1);
	 if (fsize<65536)
	 {
		fread(tekst,fsize,1,f);
		tekst[fsize]='\0';
		result=gadaj(tekst);
	 } else gadaj("Plik zbyt duy");
	 fclose(f);
	 free(tekst);
 };
 return(result);
};
//=========================================================================================
BOOL czytajplikSynTalk(LPSTR nazwa)
{
 char *tekst;
 FILE *f;
 BOOL result=FALSE;
 int fsize;
 if ((f=fopen(nazwa,"rt"))!=NULL)
 {
	 fseek(f,0,SEEK_END);
	 fsize=ftell(f);
	 fseek(f,0,SEEK_SET);
	 tekst=(char *)malloc(fsize+1);
	 if (fsize<65536)
	 {
		fread(tekst,fsize,1,f);
		tekst[fsize]='\0';
		result=gadaj(tekst);
	 } else gadaj("Plik zbyt duy");
	 fclose(f);
	 free(tekst);
 };
 return(result);
};
//=========================================================================================
void ThreadProc(void *dummy)
{
	InicjalizujSerwer();
		
	DialogBox(hModule,MAKEINTRESOURCE(IDD_MAIN),NULL,DlgProc);

	MenuSet((DWORD)MenuProc,ptaszek[active]);
	_endthread();	
}
//=========================================================================================
UINT CALLBACK MenuProc(UINT status)
{
	
	thread=(HANDLE)_beginthread(ThreadProc,0,NULL);
	
	return ptaszek[active];
}
//=========================================================================================
void CALLBACK ProfileProc(char *profile)
{
	char *fname,temp[256];

	strcpy(temp,profile);
	fname=strrchr(temp,'\\');
	*fname=0;
	fname=strrchr(temp,'\\')+1;
	strcpy(username,fname);
	strcpy(userdirectory,profile);
	InicjalizujSerwer();
	WczytajCFG();
	MenuSet((DWORD)MenuProc,ptaszek[active]);
}

//=========================================================================================
void CALLBACK BuddyProc()
{
	WczytajCFG();
};

//=========================================================================================

int WINAPI RMKSend(SOCKET s,
			const char FAR * buf,
			int len,
			int flags)
{
    int result=0;
	int *p;
	int static header=0;
	int l;
	int	i;
    
	struct gg_send_msg *wiadomosc;

	result=_send(s,buf,len,flags);

	if (active)
	{
		p=(int *)buf;
		header=(*p);

		l=*(p+1);
		if (!l) header=0;
	
		if(header==0x000b)
		{
			if (l=len)
			{
				wiadomosc=(struct gg_send_msg *)(buf+8);
				i=znajdz_kontakt(wiadomosc->recipient);
				if (i>ile_kontaktow) i=0;
				if ((kontakty[i].czy_czytac_do) && (outcoming)) gadaj(wiadomosc->message);
			}
		}
	};

	return(result);
};

//=========================================================================================

int WINAPI RMKRecv(SOCKET s,       
			char FAR* buf,  
			int len,        
			int flags)
{
	char *zmienil[]={"zmieni","zmienia"};
	int result=0;
	int *p;
	int static header=0;
	int l;
	int i;
	char tekst[512];
	char opis[512];
    
	struct gg_recv_msg *wiadomosc;
	struct gg_notify_reply *status;
//	struct gg_status *status2;

	result=_recv(s,buf,len,flags);

	if (active)
	{
		if (len==8)
		{
			p=(int *)buf;
			header=(*p);
	
			l=*(p+1);
			if (!l) header=0;
		}
		else
		{
			if(header==0x000a)
			{
				if (l=len)
				{
					wiadomosc=(struct gg_recv_msg *)buf;
					i=znajdz_kontakt(wiadomosc->sender);
					if (i>ile_kontaktow) i=0;
					if ((kontakty[i].czy_czytac_od) && (incoming)) {
						strcpy(tekst,"");
						if (intro) {
							strcpy(tekst,kontakty[i].wyswietlana);
							strcat(tekst," pisze ");
							strcat(tekst,wiadomosc->message);
						};
						if (!intro) strcpy(tekst,wiadomosc->message);
						gadaj(tekst);
					};
					header=0;
				}
			};
			if((header==0x0011) || (header==0x000f))
			{
					//gadaj("status");
					status=(struct gg_notify_reply *)buf;
					//status2.UIN:=status2.UIN and $0FFFFFF;
					status->uin=status->uin & 0x0FFFFFF;
					i=znajdz_kontakt(status->uin);
					//gadaj(itoa(status->uin,tekst,10));
					if ((kontakty[i].czy_powiadamiac) && (change))
					{
						strcpy(tekst,kontakty[i].wyswietlana);
						strcat(tekst," ");
						strcat(tekst,zmienil[kontakty[i].czy_dziewczynka]);
						strcat(tekst," status na ");
						//status->description[len-19]='\0';
						strcpy(opis,status->description);
						opis[len-19+5]='\0';
						switch (status->status)
						{
							case 0x0001:  strcat(tekst,"niedostpny lub niewidoczny"); break;
							case 0x0002:  strcat(tekst,"dostpny"); break;
							case 0x0003:  strcat(tekst,"zaraz wracam"); break;
							case 0x0004:  strcat(tekst,"dostpny z opisem treci "); strcat(tekst,opis); break;
							case 0x0005:  strcat(tekst,"zaraz wracam  z opisem treci "); strcat(tekst,opis); break;
							case 0x0006:  strcat(tekst,"na zablokowany "); break;
							case 0x0014:  strcat(tekst,"niewidoczny"); break;
							case 0x0015:  strcat(tekst,"niedostpny lub niewidoczny z opisem treci "); strcat(tekst,opis); break;
							case 0x0016:  strcat(tekst,"niewidoczny z opisem treci "); strcat(tekst,opis); break;
						};						
						gadaj(tekst);
						header=0;
					};					
			};
/*			if(header==0x0002)
			{
					//gadaj("status");
					status2=(struct gg_status *)buf;
					//status2.UIN:=status2.UIN and $0FFFFFF;
					status2->uin=status2->uin & 0x0FFFFFF;
					i=znajdz_kontakt(status2->uin);
					//gadaj(itoa(status->uin,tekst,10));
					if ((kontakty[i].czy_powiadamiac) && (change))
					{
						strcpy(tekst,kontakty[i].wyswietlana);
						strcat(tekst," ");
						strcat(tekst,zmienil[kontakty[i].czy_dziewczynka]);
						strcat(tekst," status na ");
						status->description[len-19]='\0';
						switch (status2->status)
						{
							case 0x0001:  strcat(tekst,"niedostpny lub niewidoczny"); break;
							case 0x0002:  strcat(tekst,"dostpny"); break;
							case 0x0003:  strcat(tekst,"zaraz wracam"); break;
							case 0x0004:  strcat(tekst,"dostpny z opisem treci "); strcat(tekst,status->description); break;
							case 0x0005:  strcat(tekst,"zaraz wracam  z opisem treci "); strcat(tekst,status->description); break;
							case 0x0006:  strcat(tekst,"na zablokowany "); break;
							case 0x0014:  strcat(tekst,"niewidoczny"); break;
							case 0x0015:  strcat(tekst,"niedostpny lub niewidoczny z opisem treci "); strcat(tekst,status->description); break;
							case 0x0016:  strcat(tekst,"niewidoczny z opisem treci "); strcat(tekst,status->description); break;
						};						
						gadaj(tekst);
						header=0;
					};					
			}; */
		};
	};


	return(result);
};

//=========================================================================================

BOOL WINAPI DllMain(HINSTANCE hMod,DWORD fdwReason,LPVOID lpvReserved)
{
	hModule=hMod;
	switch(fdwReason)
	{
		case DLL_PROCESS_ATTACH:

			if(!InitPlug())
				return FALSE;
			MenuInit((DWORD)MenuProc,"Gadacz",ptaszek[active]);
			OnProfileChange((DWORD)ProfileProc);
			OnBuddyListChange((DWORD)BuddyProc);
			Hook("wsock32.dll","send",(DWORD)RMKSend,(DWORD)&_send);
			Hook("wsock32.dll","recv",(DWORD)RMKRecv,(DWORD)&_recv);
			DisableThreadLibraryCalls(hMod);
			break;

	}
	return TRUE;
}
//=========================================================================================
