/*
 * Decompiled with CFR 0.152.
 */
package pl.przemelek.proxy;

import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.List;
import pl.przemelek.proxy.CommandListener;
import pl.przemelek.proxy.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StreamCopier
implements Runnable {
    private InputStream is;
    private OutputStream os;
    private Socket socket;
    private Socket client;
    private List<CommandListener> listeners;

    public StreamCopier(InputStream is, OutputStream os, Socket socket, Socket client, List<CommandListener> listeners) {
        this.is = is;
        this.os = os;
        this.socket = socket;
        this.client = client;
        this.listeners = listeners;
    }

    @Override
    public void run() {
        boolean terminate = false;
        Proxy.log(Thread.currentThread() + " " + this.socket.getInetAddress());
        while (this.socket.isConnected() && this.client.isConnected() && !terminate && !this.socket.isClosed() && !this.client.isClosed()) {
            byte[] buffer = new byte[1024];
            if (this.is != null) {
                try {
                    int readCount = this.is.read(buffer);
                    if (readCount < 0) break;
                    this.os.write(buffer, 0, readCount);
                    this.os.flush();
                    Proxy.log(String.valueOf(Thread.currentThread().getName()) + " copied " + readCount + " bytes");
                    this.sendToListeners(buffer, readCount, this.is);
                }
                catch (Exception e) {
                    Proxy.log("Exeption in " + Thread.currentThread());
                    e.printStackTrace();
                    terminate = true;
                }
                continue;
            }
            terminate = true;
        }
        try {
            this.is.close();
            this.os.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void sendToListeners(byte[] bytes, int length, InputStream is) {
        if (this.listeners != null) {
            for (CommandListener listener : this.listeners) {
                if (!"CONNECT".equals(listener.getCommand())) continue;
                listener.handle(bytes, length, is);
            }
        }
    }
}

