/*
 * Decompiled with CFR 0.152.
 */
package pl.przemelek.proxy;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.List;
import pl.przemelek.proxy.CommandListener;
import pl.przemelek.proxy.Proxy;
import pl.przemelek.proxy.StreamCopier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConnection
implements Runnable {
    private Socket client;
    private List<CommandListener> listeners;
    private String addr;

    public ServerConnection(Socket client) {
        this(client, null);
    }

    public ServerConnection(Socket client, List<CommandListener> listeners) {
        this.client = client;
        this.listeners = listeners;
    }

    @Override
    public void run() {
        block18: {
            try {
                Proxy.addConnection(this);
                OutputStream clientOutputStream = this.client.getOutputStream();
                InputStream clientInputStream = this.client.getInputStream();
                boolean tunel = false;
                try {
                    try {
                        String line = this.readLine(clientInputStream);
                        this.addr = String.valueOf(Thread.currentThread().getName()) + " " + line;
                        String[] elems = line.split(" ");
                        Proxy.log("len(elems)=" + elems.length);
                        int port = 80;
                        Proxy.log(line);
                        Proxy.log("!!!!" + Thread.currentThread() + " Method:" + elems[0]);
                        String addr = elems[1].substring(7);
                        if ("CONNECT".equals(elems[0])) {
                            addr = elems[1];
                            tunel = true;
                        }
                        int slashPos = addr.indexOf("/");
                        String path = "";
                        if (slashPos != -1) {
                            path = addr.substring(slashPos);
                            addr = addr.substring(0, slashPos);
                        } else {
                            path = "/";
                        }
                        int colonPos = addr.indexOf(":");
                        if (tunel) {
                            path = elems[1];
                        }
                        Proxy.log("addr=" + addr + " " + colonPos);
                        if (colonPos > 0) {
                            port = Integer.valueOf(addr.substring(colonPos + 1));
                            addr = addr.substring(0, colonPos);
                        }
                        elems[1] = path;
                        line = elems[0];
                        int i = 1;
                        while (i < elems.length) {
                            line = String.valueOf(line) + " " + elems[i];
                            ++i;
                        }
                        Proxy.log("====OPEN CONNECTION TO:" + addr + ":" + port);
                        Socket socket = new Socket(InetAddress.getByName(addr), port);
                        byte[] buffer = new byte[1024];
                        OutputStream os = socket.getOutputStream();
                        if (!tunel) {
                            this.handleHTTPCommand(clientOutputStream, clientInputStream, line, port, addr, socket, buffer, os);
                        } else {
                            this.handleConnectCommand(clientOutputStream, clientInputStream, socket, os);
                        }
                    }
                    catch (Exception e) {
                        clientOutputStream.write("HTTP/1.1 404 Error\r\n\r\nError 404".getBytes());
                        Proxy.log(e.getMessage());
                        e.printStackTrace();
                        if (!tunel) {
                            clientOutputStream.close();
                            clientInputStream.close();
                        }
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    if (!tunel) {
                        clientOutputStream.close();
                        clientInputStream.close();
                    }
                    throw throwable;
                }
                if (!tunel) {
                    clientOutputStream.close();
                    clientInputStream.close();
                }
            }
            catch (Exception e) {
                Proxy.log(e.getMessage());
                e.printStackTrace();
            }
        }
        Proxy.removeConnection(this);
    }

    private void handleConnectCommand(OutputStream clientOutputStream, InputStream clientInputStream, Socket socket, OutputStream os) throws IOException {
        InputStream serverInputStream = socket.getInputStream();
        OutputStream serverOutputStream = os;
        clientOutputStream.write("HTTP/1.0 200 Connection established\r\n\r\n".getBytes());
        clientOutputStream.flush();
        Proxy.log("Tunel established");
        String line2 = this.readLine(clientInputStream);
        while (!"\r\n".equals(line2)) {
            Proxy.log("0@@@" + line2);
            line2 = this.readLine(clientInputStream);
        }
        new Thread((Runnable)new StreamCopier(serverInputStream, clientOutputStream, socket, this.client, this.listeners), "server->client").start();
        new Thread((Runnable)new StreamCopier(clientInputStream, serverOutputStream, this.client, socket, this.listeners), "client->server").start();
    }

    private void handleHTTPCommand(OutputStream clientOutputStream, InputStream clientInputStream, String line, int port, String addr, Socket socket, byte[] buffer, OutputStream os) throws IOException {
        int readCount = clientInputStream.read(buffer);
        String method = line.split(" ")[0];
        os.write(line.getBytes());
        Proxy.log(Thread.currentThread() + " addr=" + addr);
        Proxy.log(Thread.currentThread() + " port=" + port);
        System.out.print(Thread.currentThread() + " " + line);
        os.write(buffer, 0, readCount);
        Proxy.log(Thread.currentThread() + " Request size:" + (line.length() + readCount));
        readCount = 0;
        String headers = "";
        String line1 = " ";
        boolean chunked = false;
        int contentSize = 0;
        BufferedInputStream sIs = new BufferedInputStream(socket.getInputStream());
        while (line1.length() > 0 && line1.charAt(0) != '\r') {
            line1 = this.readLine(sIs);
            Proxy.log(line1);
            if (line1.indexOf("Transfer-Encoding: chunked") != -1) {
                chunked = true;
            }
            headers = String.valueOf(headers) + line1;
        }
        Proxy.log(Thread.currentThread() + " Response headers size:" + headers.length());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        if (chunked) {
            boolean firstChunk = true;
            while (true) {
                int size;
                if (!firstChunk) {
                    this.readLine(sIs);
                }
                if ((size = Integer.valueOf((line1 = this.readLine(sIs)).substring(0, line1.length() - 2), 16).intValue()) != 0) {
                    int readCount1;
                    byte[] buf = new byte[size];
                    int toRead = size;
                    ByteArrayOutputStream baos2 = new ByteArrayOutputStream();
                    while ((readCount1 = ((InputStream)sIs).read(buf, 0, toRead)) > 0) {
                        baos2.write(buf, 0, readCount1);
                        if ((toRead -= readCount1) == 0) break;
                    }
                    baos.write((String.valueOf(!firstChunk ? "\r\n" : "") + Integer.toHexString(baos2.size()) + "\r\n").getBytes());
                    firstChunk = false;
                    baos.write(baos2.toByteArray());
                    continue;
                }
                break;
            }
        } else {
            int readCount1;
            byte[] buf = new byte[contentSize];
            int toRead = contentSize;
            while ((readCount1 = ((InputStream)sIs).read(buf, 0, toRead)) > 0) {
                baos.write(buf, 0, readCount1);
                if ((toRead -= readCount1) == 0) break;
            }
            if (contentSize == 0 && ((InputStream)sIs).available() > 0) {
                Proxy.log("contentSize is 0, but sIs.available is " + ((InputStream)sIs).available());
                ByteArrayOutputStream baos3 = new ByteArrayOutputStream();
                int value = 0;
                int len = 0;
                while (((InputStream)sIs).available() > 0 && (value = ((InputStream)sIs).read()) != -1) {
                    baos3.write(value);
                    ++len;
                }
                Proxy.log("copied " + len + " bytes");
                baos.write(baos3.toByteArray());
            }
        }
        clientOutputStream.write(headers.getBytes());
        clientOutputStream.write(baos.toByteArray());
        baos.close();
        ((InputStream)sIs).close();
        clientInputStream.close();
        clientOutputStream.close();
        os.close();
    }

    private String readLine(InputStream in) throws IOException {
        int inByte = 0;
        byte[] bytes = new byte[16384];
        int bytesIdx = 0;
        int available = in.available();
        while (inByte != 10) {
            Proxy.log("ReadLine, available " + available + " read byte is " + inByte);
            Proxy.log("in.available()=" + in.available());
            inByte = in.read();
            if (inByte == -1) break;
            bytes[bytesIdx++] = (byte)inByte;
        }
        String line = new String(bytes, 0, bytesIdx);
        return line;
    }

    public String toString() {
        if (this.addr != null) {
            return this.addr;
        }
        return super.toString();
    }
}

