/*
 * Decompiled with CFR 0.152.
 */
package pl.przemelek.proxy;

import java.io.IOException;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import pl.przemelek.gadacz.debug.ConnectionsListWindow;
import pl.przemelek.proxy.CommandListener;
import pl.przemelek.proxy.ServerConnection;

public class Proxy {
    static final String TRANSFER_ENCODING_CHUNKED = "Transfer-Encoding: chunked";
    static final String CONTENT_LENGTH = "Content-Length: ";
    public static ConnectionsListWindow debugWindow;
    private static boolean debug;
    private List<CommandListener> listeners;

    static {
        debug = false;
        if (debug) {
            debugWindow = new ConnectionsListWindow();
        }
    }

    static void log(String str) {
        if (debug) {
            System.out.println(Thread.currentThread() + " " + str);
        }
    }

    public static void main(String[] args) throws IOException {
        Properties systemProperties = System.getProperties();
        int port = 8081;
        if (args.length == 1) {
            port = Integer.valueOf(args[0]);
        }
        Proxy proxy = new Proxy();
        proxy.startProxy(port);
    }

    public void addListener(CommandListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<CommandListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(CommandListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<CommandListener>();
        }
        this.listeners.remove(listener);
    }

    public void startProxy(int port) throws IOException {
        Proxy.log("Start on port " + port);
        final ServerSocket servSocket = new ServerSocket(port);
        int i = 0;
        while (i < 1) {
            new Thread(new Runnable(){

                public void run() {
                    while (true) {
                        try {
                            while (true) {
                                new Thread(new ServerConnection(servSocket.accept(), Proxy.this.listeners)).start();
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
            }).start();
            ++i;
        }
    }

    public static void removeConnection(ServerConnection serverConnection) {
        if (debug) {
            debugWindow.removeConnection(serverConnection);
        }
    }

    public static void addConnection(ServerConnection serverConnection) {
        if (debug) {
            debugWindow.addConnection(serverConnection);
        }
    }
}

