/*
 * Decompiled with CFR 0.152.
 */
package pl.przemelek.gadacz.gg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import pl.przemelek.gadacz.tts.SpeechSynthezier;
import pl.przemelek.proxy.ConnectCommandListener;

public class GGSendAndRecvMessage
extends ConnectCommandListener {
    private SpeechSynthezier synthezier;
    private Map<InputStream, ByteArrayOutputStream> baoses;

    public GGSendAndRecvMessage(SpeechSynthezier synthezier) {
        this.synthezier = synthezier;
        this.baoses = new WeakHashMap<InputStream, ByteArrayOutputStream>();
    }

    public void setSynthesier(SpeechSynthezier synthezier) {
        this.synthezier = synthezier;
    }

    private long rotate(int value) {
        long ret = 0L;
        ret = ((value & 0xFF) << 24) + ((value & 0xFF00) << 8) + ((value & 0xFF0000) >> 8) + (value >> 24 & 0xFF);
        return ret;
    }

    public void handle(byte[] bytes, int length, InputStream is) {
        ByteArrayOutputStream baos = this.baoses.get(is);
        if (baos == null) {
            baos = new ByteArrayOutputStream();
            this.baoses.put(is, baos);
        }
        baos.write(bytes, 0, length);
        byte[] buffer = baos.toByteArray();
        boolean somethingInteresting = false;
        if (buffer[0] == 45 && buffer[1] == 0 && buffer[2] == 0 && buffer[3] == 0) {
            somethingInteresting = true;
        } else if (buffer[0] == 46 && buffer[1] == 0 && buffer[2] == 0 && buffer[3] == 0) {
            somethingInteresting = true;
        } else if (buffer[0] == 10 && buffer[1] == 0 && buffer[2] == 0 && buffer[3] == 0) {
            somethingInteresting = true;
        } else if (buffer[0] == 11 && buffer[1] == 0 && buffer[2] == 0 && buffer[3] == 0) {
            somethingInteresting = true;
        }
        if (!somethingInteresting) {
            baos.reset();
            return;
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(buffer, 0, buffer.length);
        DataInputStream dis = new DataInputStream(bais);
        try {
            long a = this.rotate(dis.readInt());
            long len = this.rotate(dis.readInt());
            if ((long)baos.size() >= len) {
                baos.reset();
                if (buffer[0] == 45 && buffer[1] == 0 && buffer[2] == 0 && buffer[3] == 0) {
                    this.handleSendMessage(buffer, buffer.length, false, true);
                } else if (buffer[0] == 46 && buffer[1] == 0 && buffer[2] == 0 && buffer[3] == 0) {
                    this.handleSendMessage(buffer, buffer.length, true, true);
                } else if (buffer[0] == 10 && buffer[1] == 0 && buffer[2] == 0 && buffer[3] == 0) {
                    this.handleSendMessage(buffer, buffer.length, true, false);
                } else if (buffer[0] == 11 && buffer[1] == 0 && buffer[2] == 0 && buffer[3] == 0) {
                    this.handleSendMessage(buffer, buffer.length, false, false);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void handleSendMessage(byte[] bytes, int length, boolean in, boolean gg80) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes, 0, length);
            DataInputStream dis = new DataInputStream(bais);
            long a = this.rotate(dis.readInt());
            long len = this.rotate(dis.readInt());
            long recipient = this.rotate(dis.readInt());
            long seq = this.rotate(dis.readInt());
            if (in) {
                long l = this.rotate(dis.readInt());
            }
            long classM = this.rotate(dis.readInt());
            long plainTextOffset = this.rotate(dis.readInt()) + 8L;
            long attributesOffset = this.rotate(dis.readInt()) + 8L;
            if (!gg80) {
                attributesOffset = plainTextOffset = (long)((4 + (in ? 1 : 0)) * 4 + 4);
                while (bytes[(int)attributesOffset] != 0) {
                    ++attributesOffset;
                }
                ++attributesOffset;
            }
            int textLen = (int)(attributesOffset - plainTextOffset) - 1;
            dis.close();
            String text = new String(bytes, (int)plainTextOffset, textLen);
            this.synthezier.speak(text);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

