/*
 * Decompiled with CFR 0.152.
 */
package pl.przemelek.gadacz;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Image;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import pl.przemelek.gadacz.config.Configuration;
import pl.przemelek.gadacz.gg.GGSendAndRecvMessage;
import pl.przemelek.gadacz.tts.Dant;
import pl.przemelek.gadacz.tts.Expressivo;
import pl.przemelek.gadacz.tts.SilentSynthezier;
import pl.przemelek.gadacz.tts.SpeechSynthezier;
import pl.przemelek.proxy.Proxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Gadacz {
    public static final String VERSION = "0.5.2";
    private String synth = "";

    public Gadacz() throws Exception {
        Proxy proxy = new Proxy();
        this.synth = Configuration.getSpeechSynthezier();
        final LinkedHashMap<String, SpeechSynthezier> syntheziers = new LinkedHashMap<String, SpeechSynthezier>();
        syntheziers.put("Expressivo", new Expressivo());
        syntheziers.put("Dant", new Dant());
        syntheziers.put("Cisza", new SilentSynthezier());
        this.showWelcomeBanner(this.synth);
        final LinkedHashMap<String, MenuItem> menuItems = new LinkedHashMap<String, MenuItem>();
        final GGSendAndRecvMessage ggSendAndRecvMessage = new GGSendAndRecvMessage(new Dant());
        PopupMenu menu = new PopupMenu("Nowy Gadacz");
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Object eventSource = e.getSource();
                SpeechSynthezier synthezier = null;
                String name = "";
                for (Map.Entry entry : menuItems.entrySet()) {
                    if (entry.getValue() == eventSource) {
                        name = (String)entry.getKey();
                        synthezier = (SpeechSynthezier)syntheziers.get(name);
                        String selectedStr = Gadacz.this.buildName(name);
                        ((MenuItem)entry.getValue()).setLabel(String.valueOf(name) + " " + selectedStr);
                        continue;
                    }
                    ((MenuItem)entry.getValue()).setLabel((String)entry.getKey());
                }
                ggSendAndRecvMessage.setSynthesier(synthezier);
                try {
                    synthezier.speak(name);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                Configuration.saveSynthezierName(name);
            }
        };
        for (Map.Entry entry : syntheziers.entrySet()) {
            SpeechSynthezier speechSynthezier = (SpeechSynthezier)entry.getValue();
            MenuItem menuItem = new MenuItem((String)entry.getKey());
            menuItem.addActionListener(actionListener);
            menuItems.put((String)entry.getKey(), menuItem);
            menu.add(menuItem);
        }
        MenuItem instruction = new MenuItem("Instrukcja obs\u0142ugi");
        instruction.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("http://gadacz.przemelek.pl/Home/NowyGadacz"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        MenuItem blog = new MenuItem("Odwied\u017a m\u00f3j blog");
        blog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("http://przemelek.blogspot.com?zGadaczaV0_52"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        MenuItem contact = new MenuItem("Kontakt z autorem");
        contact.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    Desktop.getDesktop().browse(new URI("http://przemelek.googlepages.com/kontakt?zGadaczaV0_52"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        MenuItem about = new MenuItem("O programie...");
        about.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Gadacz.this.getAboutWindow(Gadacz.this.synth);
            }
        });
        MenuItem exit = new MenuItem("Zamknij");
        exit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        menu.addSeparator();
        menu.add(instruction);
        menu.add(blog);
        menu.add(contact);
        menu.add(about);
        menu.addSeparator();
        menu.add(exit);
        Image img = new BufferedImage(16, 16, 5);
        InputStream is = this.getClass().getClassLoader().getResourceAsStream("NowyGadacz.gif");
        byte[] buf = new byte[10240];
        try {
            int size = is.read(buf);
            img = new ImageIcon(Arrays.copyOf(buf, size)).getImage();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SystemTray.getSystemTray().add(new TrayIcon(img, "Nowy Gadacz :-) v0.5.2", menu));
        this.setCurrentSynthezier(proxy, this.synth, ggSendAndRecvMessage, syntheziers, menuItems);
        proxy.startProxy(8081);
        new Thread(new Runnable(){

            public void run() {
                boolean tryAgain = true;
                int minutes = 2;
                while (tryAgain) {
                    try {
                        String checkUpdates = "http://www.przemelek.pl/versions/NowyGadaczUpdates?currVer=0.5.2";
                        BufferedReader br = new BufferedReader(new InputStreamReader(new URL(checkUpdates).openStream()));
                        tryAgain = false;
                        String avVersion = br.readLine();
                        String linkToInfo = "";
                        try {
                            linkToInfo = br.readLine();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (avVersion.compareTo(Gadacz.VERSION) <= 0) break;
                        String msg = "Dost\u0119pna jest nowa (" + avVersion + ") wersja Nowego Gadacza!!!\n";
                        msg = String.valueOf(msg) + "\nW celu pobrania udaj si\u0119 na mojego bloga [mo\u017cesz to zrobi\u0107 poprzez jedn\u0105 z opcji w menu Nowego Gadacza].";
                        JOptionPane.showMessageDialog(null, msg, "Informacja o nowej wersji", 1);
                        if (!linkToInfo.startsWith("http")) break;
                        try {
                            Desktop.getDesktop().browse(new URI(linkToInfo));
                        }
                        catch (Exception exception) {}
                        break;
                    }
                    catch (Exception exception) {
                        try {
                            Thread.sleep(minutes * 60 * 1000);
                            if (minutes >= 60) continue;
                            minutes *= 2;
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
        }).start();
    }

    private String buildName(String name) {
        HashMap<String, String> selectedStrings = new HashMap<String, String>();
        selectedStrings.put("o", "wybrane");
        selectedStrings.put("a", "wybrana");
        String selectedStr = (String)selectedStrings.get(name.substring(name.length() - 1));
        if (selectedStr == null) {
            selectedStr = "wybrany";
        }
        return selectedStr;
    }

    private void showWelcomeBanner(final String synth) {
        new Thread(new Runnable(){

            public void run() {
                final JFrame frame = Gadacz.this.getAboutWindow(synth);
                Timer timer = new Timer();
                TimerTask task = new TimerTask(){

                    public void run() {
                        frame.setVisible(false);
                    }
                };
                timer.schedule(task, 10000L);
            }
        }).start();
    }

    private JFrame getAboutWindow(String synth) {
        String msg = "Nowy Gadacz jest obecnie w fazie test\u00f3w, dlatego mo\u017ce dzia\u0142a\u0107 dziwnie, albo nie dzia\u0142a\u0107 w og\u00f3le.\n\n";
        msg = String.valueOf(msg) + "Informacje o najnowszej wersji znajdziesz zawsze na moim blogu.\n\n";
        msg = String.valueOf(msg) + "\n\nTwoja konfiguracja:\nWersja Nowego Gadacza: 0.5.2\nNowy Gadacz b\u0119dzie u\u017cywa\u0142 syntezatora: " + synth;
        msg = String.valueOf(msg) + "\n\nWi\u0119cej szczeg\u00f3\u0142\u00f3w o Nowy Gadaczu i innych moich \"produktach\" znajdziesz na moim blogu http://przemelek.blogspot.com\n";
        msg = String.valueOf(msg) + "Powiedz mi co my\u015blisz o Nowy Gadaczu.";
        msg = String.valueOf(msg) + "\n\n\n(c) 2002-" + Calendar.getInstance().get(1) + " by Przemys\u0142aw Rumik";
        final JFrame frame = new JFrame("Informacje");
        frame.setLayout(new BorderLayout());
        JTextArea textArea = new JTextArea(msg);
        textArea.setEditable(false);
        textArea.setWrapStyleWord(true);
        frame.setSize(700, 400);
        frame.add(textArea);
        JButton closeButton = new JButton("Zamknij");
        frame.add((Component)closeButton, "South");
        closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                frame.setVisible(false);
            }
        });
        frame.setVisible(true);
        frame.toFront();
        return frame;
    }

    private void setCurrentSynthezier(Proxy proxy, String synth, GGSendAndRecvMessage ggSendAndRecvMessage, Map<String, SpeechSynthezier> syntheziers, Map<String, MenuItem> menuItems) {
        ggSendAndRecvMessage.setSynthesier(syntheziers.get(synth));
        proxy.addListener(ggSendAndRecvMessage);
        String selectedStr = this.buildName(synth);
        menuItems.get(synth).setLabel(String.valueOf(synth) + " " + selectedStr);
    }

    public static void main(String[] args) throws Exception {
        new Gadacz();
    }
}

